import { Injectable } from '@angular/core';
import { Http } from '@angular/http';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/toPromise';
import { ShopListModel } from "../../models/pages/shop-list.model";

/*
  Generated class for the ShopListServiceProvider provider.

  See https://angular.io/docs/ts/latest/guide/dependency-injection.html
  for more info on providers and Angular DI.
*/
@Injectable()
export class ShopListServiceProvider {

  constructor(public http: Http) {
    console.log('Hello ShopListServiceProvider Provider');
  }

  getShopListData(): Promise<ShopListModel> {
    return this.http.get('./assets/json/shop-list.json')
      .toPromise()
      .then(response => response.json() as ShopListModel)
      .catch(this.handleError);
  }

  private handleError(error: any): Promise<any> {
    return Promise.reject(error.message || error);
  }

}
