import { Injectable } from '@angular/core';
import { Http } from '@angular/http';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/toPromise';
import { ShopDetailModel } from "../../models/pages/shop-detail";

/*
  Generated class for the ShopDetailServiceProvider provider.

  See https://angular.io/docs/ts/latest/guide/dependency-injection.html
  for more info on providers and Angular DI.
*/
@Injectable()
export class ShopDetailServiceProvider {

  constructor(public http: Http) {
    console.log('Hello ShopDetailServiceProvider Provider');
  }

  getProductListData(): Promise<ShopDetailModel> {
    return this.http.get('./assets/json/shop-detail.json')
      .toPromise()
      .then(response => response.json() as ShopDetailModel)
      .catch(this.handleError);
  }

  private handleError(error: any): Promise<any> {
    return Promise.reject(error.message || error);
  }

}
