import { Component } from '@angular/core';
import { NavController, NavParams, App } from 'ionic-angular';

import { ProductDetailPage } from "../product-detail/product-detail";
import { ShopDetailServiceProvider } from "../../providers/shop-detail-service/shop-detail-service";
import { ShopDetailModel } from "../../models/pages/shop-detail";
import { LoadingProvider } from '../../providers/loading/loading';
/**
 * Generated class for the ShopDetailPage page.
 *
 * See http://ionicframework.com/docs/components/#navigation for more info
 * on Ionic pages and navigation.
 */

@Component({
  selector: 'page-shop-detail',
  templateUrl: 'shop-detail.html',
})
export class ShopDetailPage {
  shopDetailData: ShopDetailModel = new ShopDetailModel();
  constructor(public navCtrl: NavController, public navParams: NavParams, public app: App, public shopDetailServiceProvider: ShopDetailServiceProvider, public loadingProvider: LoadingProvider) {

  }

  ionViewDidLoad() {
    console.log('ionViewDidLoad ShopDetailPage');
    this.getShopDetail();
  }

  getShopDetail() {
    this.loadingProvider.onLoading();

    this.shopDetailServiceProvider.getProductListData().then((data) => {
      this.shopDetailData = data;
      this.loadingProvider.dismiss();
    }, (error) => {
      this.loadingProvider.dismiss();
      console.log(error);
    });
  }

  goToDetail(item) {
    this.app.getRootNav().push(ProductDetailPage);
  }

}
