import { Component, ElementRef } from '@angular/core';
import { NavController, NavParams, App } from 'ionic-angular';

import { CheckoutPage } from "../checkout/checkout";

import { HeaderContentProvider } from "../../providers/header-content/header-content";
import { CartServiceProvider } from "../../providers/cart-service/cart-service";
import { CartModel } from "../../models/pages/cart.model";
import { LoadingProvider } from '../../providers/loading/loading';

/**
 * Generated class for the CartPage page.
 *
 * See http://ionicframework.com/docs/components/#navigation for more info
 * on Ionic pages and navigation.
 */

@Component({
  selector: 'page-cart',
  templateUrl: 'cart.html',
})
export class CartPage {
  cartData: CartModel = new CartModel();
  constructor(
    public navCtrl: NavController,
    public navParams: NavParams,
    public myElement: ElementRef,
    public headerContentProvider: HeaderContentProvider,
    public app: App,
    public cartServiceProvider: CartServiceProvider,
    public loadingProvider: LoadingProvider) {
  }

  ionViewDidLoad() {
    console.log('CartPage');
    this.getCart();
  }

  getCart() {
    this.loadingProvider.onLoading();

    this.cartServiceProvider.getCartData().then((data) => {
      this.cartData = data;
      this.loadingProvider.dismiss();
    }, (error) => {
      console.log(error);
      this.loadingProvider.dismiss();
    });
  }

  increaseItem(item) {
    item.qty++;
    this.cartCalculate();
  }

  decreaseItem(item) {
    if (item.qty > 1) {
      item.qty--;
      this.cartCalculate();
    }
  }

  onRemoveItem(index) {
    this.cartData.items.splice(index, 1);
    this.cartCalculate();
  }

  cartCalculate() {
    let cart = this.cartData;
    cart.amount = 0;
    cart.discount = 0;
    cart.totalamount = 0;
    for (var i = 0; i < cart.items.length; i++) {
      cart.items[i].price = cart.items[i].product.price * cart.items[i].qty;
      cart.items[i].discount = cart.items[i].product.discount * cart.items[i].qty;
      cart.items[i].amount = cart.items[i].product.amount * cart.items[i].qty;

      cart.amount += cart.items[i].price;
      cart.discount += cart.items[i].discount;
      cart.totalamount += cart.items[i].amount;
    }
    window.localStorage.setItem('e3cart', JSON.stringify(cart));

  }

  checkout() {
    this.app.getRootNav().push(CheckoutPage);
  }

}
