import { BrowserModule } from '@angular/platform-browser';
import { ErrorHandler, NgModule } from '@angular/core';
import { IonicApp, IonicErrorHandler, IonicModule } from 'ionic-angular';
import { HttpModule } from '@angular/http';

import { MyApp } from './app.component';
import { HomePage } from '../pages/home/home';
import { TabsPage } from "../pages/tabs/tabs";
import { AboutPage } from "../pages/about/about";
import { SettingPage } from "../pages/setting/setting";
import { AuthenPage } from "../pages/authen/authen";
import { SearchPage } from "../pages/search/search";
import { ProductDetailPage } from "../pages/product-detail/product-detail";
import { ProductListPage } from "../pages/product-list/product-list";
import { ShopListPage } from "../pages/shop-list/shop-list";
import { CartPage } from "../pages/cart/cart";
import { FavoritePage } from "../pages/favorite/favorite";
import { HelpPage } from "../pages/help/help";
import { PolicyPage } from "../pages/policy/policy";
import { AddressPage } from "../pages/address/address";
import { HistoryPage } from "../pages/history/history";
import { NotificationPage } from "../pages/notification/notification";
import { CheckoutPage } from "../pages/checkout/checkout";
import { CategoryPage } from "../pages/category/category";

import { StatusBar } from '@ionic-native/status-bar';
import { SplashScreen } from '@ionic-native/splash-screen';
import { ShopDetailPage } from "../pages/shop-detail/shop-detail";
import { Ionic2RatingModule } from 'ionic2-rating';

import { HeaderContentProvider } from '../providers/header-content/header-content';
import { IonGridScrollXComponent } from '../components/ion-grid-scroll-x/ion-grid-scroll-x';
import { IonGridImageScrollYComponent } from '../components/ion-grid-image-scroll-y/ion-grid-image-scroll-y';
import { IonListProductComponent } from '../components/ion-list-product/ion-list-product';
import { PreloadImage } from "../components/preload-image/preload-image";
import { IonListShopComponent } from '../components/ion-list-shop/ion-list-shop';
import { CardRenderComponent } from '../components/card-render/card-render';
import { FormWizardComponent } from "../components/form-wizard/form-wizard";
import { HomeServiceProvider } from '../providers/home-service/home-service';
import { ProductListServiceProvider } from '../providers/product-list-service/product-list-service';
import { ShopListServiceProvider } from '../providers/shop-list-service/shop-list-service';
import { ProductDetailServiceProvider } from '../providers/product-detail-service/product-detail-service';
import { FavoriteServiceProvider } from '../providers/favorite-service/favorite-service';
import { ShopDetailServiceProvider } from '../providers/shop-detail-service/shop-detail-service';
import { CartServiceProvider } from '../providers/cart-service/cart-service';
import { LoadingProvider } from '../providers/loading/loading';
import { CategoryServiceProvider } from '../providers/category-service/category-service';
@NgModule({
  declarations: [
    MyApp,
    HomePage,
    TabsPage,
    AboutPage,
    SettingPage,
    AuthenPage,
    ShopDetailPage,
    SearchPage,
    ProductDetailPage,
    ProductListPage,
    ShopListPage,
    CartPage,
    FavoritePage,
    HelpPage,
    PolicyPage,
    AddressPage,
    HistoryPage,
    NotificationPage,
    CheckoutPage,
    CategoryPage,

    IonGridScrollXComponent,
    IonGridImageScrollYComponent,
    IonListProductComponent,
    PreloadImage,
    IonListShopComponent,
    CardRenderComponent,
    FormWizardComponent
  ],
  imports: [
    BrowserModule,
    HttpModule,
    IonicModule.forRoot(MyApp, {
      mode: 'md',
      backButtonText: '',
      iconMode: 'md',
      modalEnter: 'modal-slide-in',
      modalLeave: 'modal-slide-out',
      tabsPlacement: 'bottom',
      pageTransition: 'md-transition'
    }),
    Ionic2RatingModule
  ],
  bootstrap: [IonicApp],
  entryComponents: [
    MyApp,
    HomePage,
    TabsPage,
    AboutPage,
    SettingPage,
    AuthenPage,
    ShopDetailPage,
    SearchPage,
    ProductDetailPage,
    ProductListPage,
    ShopListPage,
    CartPage,
    FavoritePage,
    HelpPage,
    PolicyPage,
    AddressPage,
    HistoryPage,
    NotificationPage,
    CheckoutPage,
    CategoryPage
  ],
  providers: [
    StatusBar,
    SplashScreen,
    { provide: ErrorHandler, useClass: IonicErrorHandler },
    HeaderContentProvider,
    HomeServiceProvider,
    ProductListServiceProvider,
    ShopListServiceProvider,
    ProductDetailServiceProvider,
    FavoriteServiceProvider,
    ShopDetailServiceProvider,
    CartServiceProvider,
    LoadingProvider,
    CategoryServiceProvider
  ]
})
export class AppModule { }
