import { Injectable } from '@angular/core';
import { Http } from '@angular/http';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/toPromise';
import { ProductListModel } from "../../models/pages/product-list.model";

/*
  Generated class for the ProductListServiceProvider provider.

  See https://angular.io/docs/ts/latest/guide/dependency-injection.html
  for more info on providers and Angular DI.
*/
@Injectable()
export class ProductListServiceProvider {

  constructor(public http: Http) {
    console.log('Hello ProductListServiceProvider Provider');
  }

  getProductListData(): Promise<ProductListModel> {
    return this.http.get('./assets/json/product-list.json')
      .toPromise()
      .then(response => response.json() as ProductListModel)
      .catch(this.handleError);
  }

  private handleError(error: any): Promise<any> {
    return Promise.reject(error.message || error);
  }

}
