import { Component } from '@angular/core';
import { NavController, NavParams, App } from 'ionic-angular';

import { ShopDetailPage } from "../shop-detail/shop-detail";
import { ShopListServiceProvider } from "../../providers/shop-list-service/shop-list-service";
import { ShopListModel } from "../../models/pages/shop-list.model";
import { LoadingProvider } from '../../providers/loading/loading';
/**
 * Generated class for the ShopListPage page.
 *
 * See http://ionicframework.com/docs/components/#navigation for more info
 * on Ionic pages and navigation.
 */

@Component({
  selector: 'page-shop-list',
  templateUrl: 'shop-list.html',
})
export class ShopListPage {
  shopListData: ShopListModel = new ShopListModel();
  constructor(
    public navCtrl: NavController,
    public navParams: NavParams,
    public app: App,
    public shopListServiceProvider: ShopListServiceProvider,
    public loadingProvider: LoadingProvider
  ) {
  }

  ionViewDidLoad() {
    console.log('ionViewDidLoad ShopListPage');
    this.getShopList();
  }

  getShopList() {
    this.loadingProvider.onLoading();
    this.shopListServiceProvider.getShopListData().then((data) => {
      this.shopListData = data;
      this.loadingProvider.dismiss();
    }, (error) => {
      console.log(error);
      this.loadingProvider.dismiss();
    });
  }

  goToShopDetail() {
    this.app.getRootNav().push(ShopDetailPage);
  }


}
