import { Component, ElementRef } from '@angular/core';
import { NavController, NavParams, App } from 'ionic-angular';

import { ProductDetailPage } from "../product-detail/product-detail";
import { ShopDetailPage } from "../shop-detail/shop-detail";

import { HeaderContentProvider } from "../../providers/header-content/header-content";
import { LoadingProvider } from '../../providers/loading/loading';
import { ProductListServiceProvider } from '../../providers/product-list-service/product-list-service';
import { ProductListModel } from '../../models/pages/product-list.model';

/**
 * Generated class for the SearchPage page.
 *
 * See http://ionicframework.com/docs/components/#navigation for more info
 * on Ionic pages and navigation.
 */

@Component({
  selector: 'page-search',
  templateUrl: 'search.html',
})
export class SearchPage {
  ionScroll: any;
  start: number = 0;
  slideHeaderPrevious: number = 0;
  hideheader: boolean;
  showheader: boolean;

  productListData: ProductListModel = new ProductListModel();

  constructor(
    public navCtrl: NavController,
    public navParams: NavParams,
    public app: App,
    public myElement: ElementRef,
    public headerContentProvider: HeaderContentProvider,
    public loadingProvider: LoadingProvider,
    public productListServiceProvider: ProductListServiceProvider
  ) {
  }

  ionViewDidLoad() {
    console.log('SearchPage');
    this.onHeaderScroll();
  }

  onHeaderScroll() {
    this.hideheader = false;
    this.showheader = true;
    this.ionScroll = this.myElement.nativeElement.getElementsByClassName('scroll-content')[0];
    this.ionScroll.addEventListener("scroll", () => {
      this.hideheader = this.headerContentProvider.getContent(this.ionScroll.scrollTop);
      this.showheader = !this.hideheader;
      if (this.slideHeaderPrevious >= this.ionScroll.scrollTop - this.start) {
        this.hideheader = false;
        this.showheader = true;
      }
      this.slideHeaderPrevious = this.ionScroll.scrollTop - this.start;
    });
  }

  onSearch() {
    this.getProductList();
  }

  getProductList() {
    this.loadingProvider.onLoading();

    this.productListServiceProvider.getProductListData().then((data) => {
      this.productListData = data;
      setTimeout(() => {
        this.loadingProvider.dismiss();
      }, 1000);
    }, (error) => {
      console.log(error);
      setTimeout(() => {
        this.loadingProvider.dismiss();
      }, 1000);
    });
  }

  goToDetail(item) {
    this.app.getRootNav().push(ProductDetailPage);
  }

}
